#version 330
#extension GL_EXT_gpu_shader4 : enable
//Alone in the NightMod01.fsh  by  stduhpf 
//https://www.shadertoy.com/view/4l33DX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
#define vlsamples 60

struct material
{
    vec3 c; //color
    float sp; //specularity
    vec4 nm; //normal map (nor,is normal mapped?)
    bool e; //is emmisive?
};
const float dist =100.;

float rand( vec3 co)
{
    return fract(sin(
            dot(vec3(30,1.3,320)*co*co,
                vec3(12.9898,8.233,-19.848))
                *43758.5453));
    }
float rand(vec2 co){
     return fract(sin(dot(co.xy ,
         vec2(12.9898,78.233))) * 43758.5453);
      }

    float mx(float a , float b , float x)
    {
        return (cos(x*3.1415)+1.)*(a-b)/2.+b;
        }
float bruit(vec3 co) //3d value noise(faster than perlin noise, that's why i don't use a true perlin noise)
{
    vec3 inco= floor(co);
    vec3 frco= fract(co);
    float x1 = mx(rand(inco),rand(inco+vec3(1,0,0)),frco.x);
    float x2 = mx(rand(inco+vec3(0,1,0)),rand(inco+vec3(1,1,0)),frco.x);
    float y1 = mx(x1,x2,frco.y);
    float x3 = mx(rand(inco+vec3(0,0,1)),rand(inco+vec3(1,0,1)),frco.x);
    float x4 = mx(rand(inco+vec3(0,1,1)),rand(inco+vec3(1,1,1)),frco.x);
    float y2 = mx(x3,x4,frco.y);
    return mx(y1,y2,frco.z);
    }
float fbm( vec3 p) // 3D fractional brownian motion
{
mat3 rot = mat3(cos(.5),sin(.5),0,-sin(.5),cos(.5),0,0,0,1);
rot*=mat3(1,0,0,0,cos(.15),sin(.15),0,-sin(.15),cos(.15));
rot*=mat3(cos(1.15),0,sin(1.15),0,1,0,-sin(1.15),0,cos(1.15));
    return bruit(vec3(p))
    +.5*bruit(2.001*vec3(p*rot))
    +.25*bruit(4.041*vec3(p*rot*rot));
    +.125*bruit(8.041*vec3(p*rot*rot*rot))
    +.1*rand(10.*p);
    }

vec2 grad(vec2 co) //2d random gradiant for perlin noise
{
return vec2(rand(co.xy+10.1),rand(3.2654*co.yx))-.5;
    }
float perlin(vec2 uv)//true 2d perlin noise
{

vec2 relco = fract(uv);
vec2 sqco  = floor(uv);

float s = dot(grad(sqco),relco);
float t = dot(grad(sqco +vec2(1,0)),relco-vec2(1,0));
float u = dot(grad(sqco +1.),relco-1.);
float v = dot(grad(sqco+ vec2(0,1)),relco-vec2(0,1));

float noise1 = mix(s,t,smoothstep(0.,1.,relco.x));
float noise2 = mix(v,u,smoothstep(0.,1.,relco.x));
return  (10.*mix(noise1,noise2,smoothstep(0.,1.,relco.y)))/2.;

    }

mat3 r(float a,vec3 m) //3D rotation os a radiants around the axis m
    {
        float c = cos(a);
        float s =sin (a);
        return mat3(c+(1.-c)*m.x*m.x,
            (1.-c)*m.x*m.y-s*m.z,
            (1.-c)*m.x*m.z+s*m.y,
            (1.-c)*m.x*m.y+s*m.z,
            c+(1.-c)*m.y*m.y,
            (1.-c)*m.y*m.z-s*m.x,
            (1.-c)*m.x*m.z-s*m.y,
            (1.-c)*m.y*m.z+s*m.x,
            c+(1.-c)*m.z*m.z);
        }

//primitives
float cube(vec3 p,vec3 shape)
{
    p+= vec3(0);
    vec3 d = abs(p)-shape;
float t = min(max(d.x,max(d.y,d.z)),0.)
+length(max(d,.0));
return t;
}
float sph(vec3 pos,float r)
{
    return length(pos)-r;
    }
float hplane(vec3 p,float h)
{
    return p.y-h;
    }
    float line( vec3 p, vec3 a, vec3 b, float r )
    {
        vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
     return length( pa - ba*h ) - r;
      }
float Cylinder( vec3 p, vec2 h )
 {
     vec2 d = abs(vec2(length(p.xz),p.y)) - h;
      return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float RoundBox( vec3 p, vec3 b, float r )
 {
    return length(max(abs(p)-b,0.0))-r;
}
float Prism( vec3 p, vec2 h )
 {
     vec3 q = abs(p);
      return max(q.z-h.y,max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5);
}

//distance operations
    float smin( float a, float b,float k) //smooth minimum by iq
{
    return -log(exp(-k*a)+exp(-k*b))/k;
}

vec2 un (vec2 a, vec2 b)//opUnion
{
    float t=min(a,b).x;
float m= b.y;
    if (a.x == t)
    m= a.y;
    return vec2(t,m);
    }

//distance fields
vec2 pot(vec3 p)
{
    p.x= mod(5.+p.x,10.)-5.-1.5*sign(p.z);
    p.z=(abs(p.z)-6.);
    float m= line(p,vec3(0,-1,0),vec3(0,5,0),.1);
    m=smin(m,line(p,vec3(0,5,0),vec3(0,5.2,-1.),.1),20.);
return un(vec2(m,2),
    vec2(sph(p-vec3(0,5,-.5),.1),3));
}

float tro(vec3 p)
{
    return max(4.-abs(p.z),p.y+clamp(abs(p.z*.126)-2.,0.,2.)*(sin(.5+p.z*.1)+sin(p.x*.15)));

}

float car(vec3 p)
{
    p.x=mod(p.x-50.*time,400.)-10.;
    p.z*=-1.;
    p=.15*p.zyx;
    vec3 q = p;
    float c = RoundBox(p,vec3(.15,.03,.22),.01);
    c= smin(c,RoundBox(p+vec3(0,-.06,0),
        vec3(.15,.045,.11),0.)
        ,25.+clamp(5.*(p.z),-10.,10.)
        );

        q=p.yxz;
    q.yz= abs(q.yz+vec2(0,.01))-vec2(.16,.13);
    q.xz+=vec2(.03,0);
     c= min(c,Cylinder(q,vec2(.04,.03)));
     c = min(c,Prism(p.zyx*vec3(1,-.75,1)+vec3(.19,.04,0),vec2(.01,.14)));
    c= min(c,line(p,vec3(-.1,.1,.075),vec3(-.1,.15,0),.003));
     return c/.15;
     }


vec2 map(vec3 pos)
{
vec2 m=vec2(hplane(pos,-.5),1);
m=un(m,vec2(tro(pos),1));
m=un(m,pot(pos));
m= un(m,vec2(car(pos+vec3(0,0,-2)),4));
return m;
}

vec2 itsc(vec3 o,vec3 d,float dis)//raycasting
{
    float t=0.;
    for(int i=0;i<500;i++)
    {
    vec2 h= map(o+t*d);
    if(h.x<.001)return vec2(h.y,t);
    if(t>dis)
    break;
    t+=h.x*.85;//the *.85 is because the "pot" distance function seems broken 
    }
    return vec2(-1,dis);
    }


vec3 normal(vec3 p)
{
    vec2 eps= vec2(.01,0);
    vec3 n=
        vec3(
            map(p+eps.xyy).x-map(p-eps.xyy).x,
        map(p+eps.yxy).x-map(p-eps.yxy).x,
        map(p+eps.yyx).x-map(p-eps.yyx).x);
return normalize(n);
    }


float ao(vec3 p,vec3 n,float d) //fast fake ambiant occlusion
{
    float h= map(p+d*n).x;
    return d/(d+(d-h));
}

material getm(float mtype, vec3 pos)
{
    material m;
    m.nm=vec4(0);
    m.sp=1.;
    m.e=false;
    if(mtype==4.)//cars
    {
        m.c=vec3(.1);
        m.sp=.3;
        }
    if(mtype==3.) //lightsource
    {
        m.c=vec3(1,1,.5);
        m.e = true;
    }
    if(mtype==2.)//streetlights
    {
    m.c=vec3(.4,.4,.4);
    m.sp=2.;
    }
    if(mtype ==1.)//ground
    {
        vec2 co =20.*pos.xz;
    vec2 e= vec2(.5,0);
    m.nm.a=1.;
m.nm.xyz= normalize(
    vec3(perlin(co+e)-perlin(co-e),
            perlin(co+e.yx)-perlin(co-e.yx),
            3.));
            m.sp=1.;
    m.c=vec3(.1,.1,.15);
    if(abs(pos.z)<.1&&mod(pos.x,2.)>.75)
    m.c= vec3(.9);
    if(abs(abs(pos.z)-4.4)<.5){
    m.c = vec3(.5)*clamp(3.*mod(pos.x+sign(pos.z),2.9),.8,1.);
    m.nm.a*=.0;
    }
    if(abs(pos.z)>4.5){
    m.c = vec3(.0,.2,.0);
    m.nm.xy*=2.;
    m.sp=.1;
    }
    m.nm=normalize(m.nm);
    }
    return m;
}

float fog(vec3 p,float d)
{
    return clamp(fbm(
        (p*2.2/(d+10.)+vec3(.02*time,0.,.05*time)))
        *(2.-smoothstep(0.,2.,p.y+.5)),0.,1.);
    }
float marchvolfog(vec3 ro,vec3 rd,float d)
{
    float den=0.;
    float t=.5;
    for(int i=0;i<11;i++)
    {
        vec3 pos= ro+t*rd;
        float n = fog(pos,t);
        n= clamp(n-fog(pos+.7-float(i)*.1,t),.08,1.);
        den+=clamp(n*smoothstep(t-.4,1.75*t+2.,d),0.,1.);
        t*=1.6;
        if(t>d)break;
    }
    return clamp(den,0.,1.);
    }


float calcscat(vec3 ro, vec3 rd, float d,vec2 fc)
{
float s=0.;
float maxdist = min(dist,d);
float w=1./float(vlsamples);
float st = maxdist*w;
vec3 pos = ro+rd*rand(vec3(fc,time))*.75;
for(int i =0;i<vlsamples;i++)
{
    vec3 p = pos;
	p.x= mod(5.+p.x,10.)-5.-1.5*sign(pos.z);
    p.z=(abs(p.z)-3.);
    vec3 ld = vec3(0,5.,2.5)-p;
    s+=itsc(pos,normalize(ld),length(ld)-.2).x<0.
        && 
        dot(normalize(vec3(0,5.,2.5)) ,normalize(ld))>.95 ?
        .2+.8*fog(pos,float(i)*w):.0;
    pos+=rd*st;
}
return clamp(s*w,0.,1.);
} 
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
vec2 ut = (iMouse.xy/iResolution.xy-.5)*vec2(8.,2.);
if(iMouse.xy==vec2(0))
    ut=vec2(1.7,0.);

mat3 rotx= mat3(cos(ut.x),0,sin(ut.x),0,1,0,-sin(ut.x),0,cos(ut.x));
mat3 roty = mat3(1,0,0,0,cos(ut.y),sin(ut.y),0,-sin(ut.y),cos(ut.y));

vec2 uv = gl_FragCoord.xy/iResolution.x-vec2(.5,.5*iResolution.y/iResolution.x);

float t= 5.*smoothstep(0.,1.,time*.01)*time;
vec3 ro =vec3(-t,
    1.+.05*cos(2.*t),
    -3.+.01*sin(4.*t));
vec3 rd = normalize(vec3(uv,-1.))*roty*rotx;

vec2 d = itsc(ro,rd,dist);
vec3 c = vec3(0);
vec3 ld = normalize(vec3(.4,2,-1.));
ld*=r(.01*time,normalize(vec3(0,1,.2)));
float light=0.;
    
if (d.x>0.)//if the ray has hit an object
{
    vec3 pos= ro+d.y*rd;
    material mat = getm(d.x,pos);
vec3 nor = normalize(normal(pos)+mat.nm.xyz*mat.nm.a);
vec3 rrd= reflect(rd,nor);
light=ao(pos,-nor,.5);
light+=(itsc(pos+.02*ld,ld,dist).x<0. ? mat.sp/distance(ld,rrd)*dot(nor,ld):0.)    ;
c=mat.c*(mat.e? 1.:light*.1);
vec3 p= pos;
    p.x= mod(5.+p.x,10.)-5.-1.5*sign(pos.z);
    p.z=(abs(p.z)-3.);
    vec3 l = vec3(0,5.,2.5)-p;
    
    //then we apply the light the light from the floor lamps
if(dot(normalize(vec3(0,5.,2.5))
    ,normalize(l))>.95)
{
    nor.z*=sign(-pos.z);
    rrd= reflect(rd,nor);
    c+=5.*vec3(1.,1.,.2)*mat.c
        *max(.1,(dot(nor,normalize(l))))
        /length(l)
        *(itsc(pos+.2*normalize(l),normalize(l),length(l)-.5).x<0.? 1.:0.)
*mat.sp/distance(normalize(l),rrd)
;
}
}else //we draw the sky
{
    vec3 bg = vec3(0,0,.1)+max(0.,(perlin(20.*rd.xz/rd.y)-1.2));
    c= mix(bg,vec3(1),.1/distance(rd,ld));
    if(1./distance(rd,ld)>10.)c=vec3(1.)+.45*(perlin(20.*rd.xz/rd.y));
}

    c= clamp(c,0.,1.);
    float fog =marchvolfog(ro,rd,d.y);
 //   vec3 fogcol=mix(vec3(.4,.3,.5),vec3(.55,.5,.2),calcscat(ro,rd,d.y,gl_FragCoord.xy)); //volumetric light

    //c= mix(c,fogcol,fog); // apply fog

    gl_FragColor = vec4(c,fog);
    gl_FragColor.a = length(gl_FragColor.rgb);
    //gl_FragColor.a = 1.0 - gl_FragColor.r;
    gl_FragColor.a = ( 1.0 - gl_FragColor.b ) * 0.92 ;
}

